#region Copyright Syncfusion Inc. 2001-2024.
// Copyright Syncfusion Inc. 2001-2024. All rights reserved.
// Use of this code is subject to the terms of our license.
// A copy of the current license can be obtained at any time by e-mailing
// licensing@syncfusion.com. Any infringement will be prosecuted under
// applicable laws. 
#endregion
using Syncfusion.Presentation;
using System;
using System.Windows.Forms;
using System.IO;
using Syncfusion.Windows.Forms;
using Syncfusion.Licensing;
using System.Reflection;
using System.Text;

namespace PPTXToPdf
{
    public partial class Form1 :  MetroForm 
    {
        #region Private Members
        private System.ComponentModel.IContainer components = null;
        #endregion

        # region Constructor
        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //            
            InitializeComponent();
            this.MinimizeBox = true;
            Application.EnableVisualStyles();
            this.txtEncryptSource.Text = "Syncfusion Presentation.pptx";
#if !NETCore
            this.txtEncryptSource.Tag = @"..\..\..\..\..\..\common\Data\Presentation\Syncfusion Presentation.pptx";
#else
            this.txtEncryptSource.Tag = @"..\..\..\..\..\..\..\common\Data\Presentation\Syncfusion Presentation.pptx";
#endif

            // TODO: Add any constructor code after InitializeComponent call
            //
        }
        /// <summary>
        /// Helper method to find a syncfusion license key from the Common folder
        /// </summary>
        /// <param name="fileName">File name of the syncfusion license key</param>
        /// <returns></returns>
        public static string FindLicenseKey()
        {
            string licenseKeyFile = "..\\common\\SyncfusionLicense.txt";
            for (int n = 0; n < 20; n++)
            {
                if (!System.IO.File.Exists(licenseKeyFile))
                {
                    licenseKeyFile = @"..\" + licenseKeyFile;
                    continue;
                }
                return File.ReadAllText(licenseKeyFile);
            }
            return string.Empty;
        }
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Form1));
            this.label2 = new System.Windows.Forms.Label();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnEncrypt = new Syncfusion.Windows.Forms.ButtonAdv();
            this.label9 = new System.Windows.Forms.Label();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.btnEncryptBrowse = new Syncfusion.Windows.Forms.ButtonAdv();
            this.txtEncryptSource = new System.Windows.Forms.TextBox();
            this.label3 = new System.Windows.Forms.Label();
            this.txtEnOpen = new System.Windows.Forms.TextBox();
            this.label4 = new System.Windows.Forms.Label();
            this.label8 = new System.Windows.Forms.Label();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.btnDecrypt = new Syncfusion.Windows.Forms.ButtonAdv();
            this.btnDecryptBrowse = new Syncfusion.Windows.Forms.ButtonAdv();
            this.txtDecryptSource = new System.Windows.Forms.TextBox();
            this.label5 = new System.Windows.Forms.Label();
            this.txtDeOpen = new System.Windows.Forms.TextBox();
            this.label6 = new System.Windows.Forms.Label();
            this.label11 = new System.Windows.Forms.Label();
            this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.openFileDialog2 = new System.Windows.Forms.OpenFileDialog();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.groupBox1.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.SuspendLayout();
            // 
            // label2
            // 
            this.label2.Font = new System.Drawing.Font("Verdana", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(161)));
            this.label2.ForeColor = System.Drawing.SystemColors.ControlText;
            this.label2.Location = new System.Drawing.Point(0, 85);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(372, 56);
            this.label2.TabIndex = 78;
            this.label2.Text = "Click the button to view the PowerPoint Presentation generated by Essential Prese" +
    "ntation. Please note that MS PowerPoint Viewer or MS PowerPoint is required to v" +
    "iew the resultant Presentation.";
            // 
            // pictureBox1
            // 
            this.pictureBox1.Dock = System.Windows.Forms.DockStyle.Top;
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(0, 0);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(372, 82);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 77;
            this.pictureBox1.TabStop = false;
            // 
            // btnEncrypt
            // 
            this.btnEncrypt.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnEncrypt.Appearance = Syncfusion.Windows.Forms.ButtonAppearance.Metro;
            this.btnEncrypt.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(17)))), ((int)(((byte)(158)))), ((int)(((byte)(218)))));
            this.btnEncrypt.BeforeTouchSize = new System.Drawing.Size(85, 21);
            this.btnEncrypt.BorderStyleAdv = Syncfusion.Windows.Forms.ButtonAdvBorderStyle.Dashed;
            this.btnEncrypt.ComboEditBackColor = System.Drawing.Color.Silver;
            this.btnEncrypt.Font = new System.Drawing.Font("Segoe UI", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnEncrypt.ForeColor = System.Drawing.Color.White;
            this.btnEncrypt.IsBackStageButton = false;
            this.btnEncrypt.KeepFocusRectangle = false;
            this.btnEncrypt.Location = new System.Drawing.Point(257, 92);
            this.btnEncrypt.Name = "btnEncrypt";
            this.btnEncrypt.Office2007ColorScheme = Syncfusion.Windows.Forms.Office2007Theme.Managed;
            this.btnEncrypt.Size = new System.Drawing.Size(85, 21);
            this.btnEncrypt.TabIndex = 76;
            this.btnEncrypt.Text = "Encrypt";
            this.btnEncrypt.UseVisualStyle = true;
            this.btnEncrypt.UseVisualStyleBackColor = false;
            this.btnEncrypt.Click += new System.EventHandler(this.btnEncrypt_Click);
            // 
            // label9
            // 
            this.label9.Location = new System.Drawing.Point(354, 178);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(20, 16);
            this.label9.TabIndex = 84;
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.btnEncryptBrowse);
            this.groupBox1.Controls.Add(this.txtEncryptSource);
            this.groupBox1.Controls.Add(this.label3);
            this.groupBox1.Controls.Add(this.btnEncrypt);
            this.groupBox1.Controls.Add(this.txtEnOpen);
            this.groupBox1.Controls.Add(this.label4);
            this.groupBox1.Font = new System.Drawing.Font("Verdana", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.groupBox1.ForeColor = System.Drawing.Color.Black;
            this.groupBox1.Location = new System.Drawing.Point(12, 144);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(348, 124);
            this.groupBox1.TabIndex = 85;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Encrypt Presentation";
            // 
            // btnEncryptBrowse
            // 
            this.btnEncryptBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnEncryptBrowse.BackColor = System.Drawing.Color.Transparent;
            this.btnEncryptBrowse.BeforeTouchSize = new System.Drawing.Size(24, 20);
            this.btnEncryptBrowse.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnEncryptBrowse.ForeColor = System.Drawing.SystemColors.ControlText;
            this.btnEncryptBrowse.IsBackStageButton = false;
            this.btnEncryptBrowse.Location = new System.Drawing.Point(318, 29);
            this.btnEncryptBrowse.Name = "btnEncryptBrowse";
            this.btnEncryptBrowse.Size = new System.Drawing.Size(24, 20);
            this.btnEncryptBrowse.TabIndex = 0;
            this.btnEncryptBrowse.Text = "...";
            this.btnEncryptBrowse.UseVisualStyleBackColor = false;
            this.btnEncryptBrowse.Click += new System.EventHandler(this.btnEncryptBrowse_Click);
            // 
            // txtEncryptSource
            // 
            this.txtEncryptSource.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtEncryptSource.Location = new System.Drawing.Point(123, 29);
            this.txtEncryptSource.Name = "txtEncryptSource";
            this.txtEncryptSource.Size = new System.Drawing.Size(172, 20);
            this.txtEncryptSource.TabIndex = 1;
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label3.ForeColor = System.Drawing.SystemColors.ControlText;
            this.label3.Location = new System.Drawing.Point(6, 32);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(93, 13);
            this.label3.TabIndex = 8;
            this.label3.Text = "Source Document";
            // 
            // txtEnOpen
            // 
            this.txtEnOpen.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtEnOpen.Location = new System.Drawing.Point(123, 60);
            this.txtEnOpen.Name = "txtEnOpen";
            this.txtEnOpen.PasswordChar = '*';
            this.txtEnOpen.Size = new System.Drawing.Size(219, 20);
            this.txtEnOpen.TabIndex = 2;
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label4.ForeColor = System.Drawing.SystemColors.ControlText;
            this.label4.Location = new System.Drawing.Point(6, 63);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(106, 13);
            this.label4.TabIndex = 3;
            this.label4.Text = "Password To Protect";
            // 
            // label8
            // 
            this.label8.BackColor = System.Drawing.Color.MidnightBlue;
            this.label8.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.label8.Location = new System.Drawing.Point(29, 13);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(118, 1);
            this.label8.TabIndex = 2;
            this.label8.Text = "label8";
            // 
            // groupBox2
            // 
            this.groupBox2.Controls.Add(this.btnDecrypt);
            this.groupBox2.Controls.Add(this.btnDecryptBrowse);
            this.groupBox2.Controls.Add(this.txtDecryptSource);
            this.groupBox2.Controls.Add(this.label5);
            this.groupBox2.Controls.Add(this.txtDeOpen);
            this.groupBox2.Controls.Add(this.label6);
            this.groupBox2.Font = new System.Drawing.Font("Verdana", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.groupBox2.ForeColor = System.Drawing.Color.Black;
            this.groupBox2.Location = new System.Drawing.Point(12, 280);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(348, 122);
            this.groupBox2.TabIndex = 86;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Decrypt Presentation";
            // 
            // btnDecrypt
            // 
            this.btnDecrypt.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDecrypt.Appearance = Syncfusion.Windows.Forms.ButtonAppearance.Metro;
            this.btnDecrypt.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(17)))), ((int)(((byte)(158)))), ((int)(((byte)(218)))));
            this.btnDecrypt.BeforeTouchSize = new System.Drawing.Size(85, 21);
            this.btnDecrypt.BorderStyleAdv = Syncfusion.Windows.Forms.ButtonAdvBorderStyle.Dashed;
            this.btnDecrypt.ComboEditBackColor = System.Drawing.Color.Silver;
            this.btnDecrypt.Font = new System.Drawing.Font("Segoe UI", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnDecrypt.ForeColor = System.Drawing.Color.White;
            this.btnDecrypt.IsBackStageButton = false;
            this.btnDecrypt.KeepFocusRectangle = false;
            this.btnDecrypt.Location = new System.Drawing.Point(257, 92);
            this.btnDecrypt.Name = "btnDecrypt";
            this.btnDecrypt.Office2007ColorScheme = Syncfusion.Windows.Forms.Office2007Theme.Managed;
            this.btnDecrypt.Size = new System.Drawing.Size(85, 21);
            this.btnDecrypt.TabIndex = 77;
            this.btnDecrypt.Text = "Decrypt";
            this.btnDecrypt.UseVisualStyle = true;
            this.btnDecrypt.UseVisualStyleBackColor = false;
            this.btnDecrypt.Click += new System.EventHandler(this.btnDecrypt_Click);
            // 
            // btnDecryptBrowse
            // 
            this.btnDecryptBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDecryptBrowse.BackColor = System.Drawing.Color.Transparent;
            this.btnDecryptBrowse.BeforeTouchSize = new System.Drawing.Size(24, 20);
            this.btnDecryptBrowse.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnDecryptBrowse.ForeColor = System.Drawing.SystemColors.ControlText;
            this.btnDecryptBrowse.IsBackStageButton = false;
            this.btnDecryptBrowse.Location = new System.Drawing.Point(318, 29);
            this.btnDecryptBrowse.Name = "btnDecryptBrowse";
            this.btnDecryptBrowse.Size = new System.Drawing.Size(24, 20);
            this.btnDecryptBrowse.TabIndex = 6;
            this.btnDecryptBrowse.Text = "...";
            this.btnDecryptBrowse.UseVisualStyleBackColor = false;
            this.btnDecryptBrowse.Click += new System.EventHandler(this.btnDecryptBrowse_Click);
            // 
            // txtDecryptSource
            // 
            this.txtDecryptSource.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtDecryptSource.Location = new System.Drawing.Point(123, 29);
            this.txtDecryptSource.Name = "txtDecryptSource";
            this.txtDecryptSource.Size = new System.Drawing.Size(172, 20);
            this.txtDecryptSource.TabIndex = 7;
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label5.ForeColor = System.Drawing.SystemColors.ControlText;
            this.label5.Location = new System.Drawing.Point(6, 32);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(93, 13);
            this.label5.TabIndex = 8;
            this.label5.Text = "Source Document";
            // 
            // txtDeOpen
            // 
            this.txtDeOpen.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtDeOpen.Location = new System.Drawing.Point(123, 60);
            this.txtDeOpen.Name = "txtDeOpen";
            this.txtDeOpen.PasswordChar = '*';
            this.txtDeOpen.Size = new System.Drawing.Size(219, 20);
            this.txtDeOpen.TabIndex = 8;
            // 
            // label6
            // 
            this.label6.AutoSize = true;
            this.label6.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label6.ForeColor = System.Drawing.SystemColors.ControlText;
            this.label6.Location = new System.Drawing.Point(6, 63);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(98, 13);
            this.label6.TabIndex = 3;
            this.label6.Text = "Password To Open";
            // 
            // label11
            // 
            this.label11.BackColor = System.Drawing.Color.MidnightBlue;
            this.label11.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.label11.Location = new System.Drawing.Point(29, 13);
            this.label11.Name = "label11";
            this.label11.Size = new System.Drawing.Size(118, 1);
            this.label11.TabIndex = 2;
            this.label11.Text = "label11";
            // 
            // openFileDialog1
            // 
            this.openFileDialog1.FileName = "openFileDialog1";
            // 
            // openFileDialog2
            // 
            this.openFileDialog2.FileName = "openFileDialog1";
            // 
            // Form1
            // 
            this.Font = new System.Drawing.Font("Segoe UI", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.BackColor = System.Drawing.Color.White;
            this.BorderColor = System.Drawing.Color.FromArgb(((int)(((byte)(17)))), ((int)(((byte)(158)))), ((int)(((byte)(218)))));
            this.ClientSize = new System.Drawing.Size(384, 432);
            this.Controls.Add(this.groupBox2);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this.label9);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.pictureBox1);
            this.DropShadow = true;
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MaximizeBox = false;
            this.Name = "Form1";
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.Text = "Encrypt and Decrypt";
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            this.groupBox2.ResumeLayout(false);
            this.groupBox2.PerformLayout();
            this.ResumeLayout(false);

        }

        #endregion

        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.PictureBox pictureBox1;
        private Syncfusion.Windows.Forms.ButtonAdv btnEncrypt;
        private System.Windows.Forms.Label label9;
        private System.Windows.Forms.GroupBox groupBox1;
        private Syncfusion.Windows.Forms.ButtonAdv btnEncryptBrowse;
        private System.Windows.Forms.TextBox txtEncryptSource;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.TextBox txtEnOpen;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.Label label8;
        private System.Windows.Forms.GroupBox groupBox2;
        private Syncfusion.Windows.Forms.ButtonAdv btnDecrypt;
        private Syncfusion.Windows.Forms.ButtonAdv btnDecryptBrowse;
        private System.Windows.Forms.TextBox txtDecryptSource;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.TextBox txtDeOpen;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.Label label11;
        private System.Windows.Forms.OpenFileDialog openFileDialog1;
        private System.Windows.Forms.ToolTip toolTip1;
        private System.Windows.Forms.OpenFileDialog openFileDialog2;

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            SyncfusionLicenseProvider.RegisterLicense(FindLicenseKey());
            Application.Run(new Form1());
        }
        #endregion

        #region Events

        private void btnEncryptBrowse_Click(object sender, EventArgs e)
        {
            openFileDialog1.FileName = "";
#if !NETCore
            openFileDialog1.InitialDirectory = Path.GetFullPath(@"..\..\..\..\..\..\common\Data\Presentation\");
#else
            openFileDialog1.InitialDirectory = Path.GetFullPath(@"..\..\..\..\..\..\..\common\Data\Presentation\");
#endif
            openFileDialog1.Filter = "PowerPoint Presentations|*.pptx";
            DialogResult result = openFileDialog1.ShowDialog();

            //Get the selected file name and display in a TextBox
            if (result == DialogResult.OK)
            {
                this.txtEncryptSource.Text = openFileDialog1.SafeFileName;
                this.txtEncryptSource.Tag = openFileDialog1.FileName;
            }

        }
        private void btnEncrypt_Click(object sender, EventArgs e)
        {
            try
            {
                if (string.IsNullOrEmpty(txtEnOpen.Text))
                {
                    MessageBox.Show("Please enter Password to protect", "Password Missing", MessageBoxButtons.OK);
                }
                else
                {
                    //Create instance for presentation with password
                    IPresentation presentation = Presentation.Open(txtEncryptSource.Tag.ToString(), txtEnOpen.Text);
                    //Encrypts the document
                    presentation.Encrypt(txtEnOpen.Text);
                    //Saves the presentation
                    presentation.Save("Encryption.pptx");
                    //Closes the presentation
                    presentation.Close();

                    if (MessageBox.Show("Do you want to view the encrypted Presentation?", "Encrypted Presentation",
                              MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.Yes)
                    {
#if !NETCore
                        System.Diagnostics.Process.Start("Encryption.pptx");
#else
                        System.Diagnostics.Process process = new System.Diagnostics.Process();
                        process.StartInfo = new System.Diagnostics.ProcessStartInfo("Encryption.pptx")
                        {
                            UseShellExecute = true
                        };
                        process.Start();
#endif
                    }
                }
            }
            catch (Exception exp)
            {
                MessageBox.Show("This Presentation could not be encrypted , please contact Syncfusion Direct-Trac system at http://www.syncfusion.com/support/default.aspx for any queries. ", "OOPS..Sorry!",
                      MessageBoxButtons.OK);
                this.Close();
            }
        }
        private void btnDecryptBrowse_Click(object sender, EventArgs e)
        {
            openFileDialog2.FileName = "";
#if !NETCore
            openFileDialog2.InitialDirectory = Path.GetFullPath(@"..\..\..\..\..\..\common\Data\Presentation\");
#else
            openFileDialog2.InitialDirectory = Path.GetFullPath(@"..\..\..\..\..\..\..\common\Data\Presentation\");
#endif
            openFileDialog2.Filter = "PowerPoint Presentations|*.pptx";
            DialogResult result = openFileDialog2.ShowDialog();

            //Get the selected file name and display in a TextBox
            if (result == DialogResult.OK)
            {
                this.txtDecryptSource.Text = openFileDialog2.SafeFileName;
                this.txtDecryptSource.Tag = openFileDialog2.FileName;
            }
        }
        private void btnDecrypt_Click(object sender, EventArgs e)
        {
            try
            {
                if (txtDecryptSource.Tag==null)
                {
                    MessageBox.Show("Please browse the files to decrypt Presentation", "Input Missing", MessageBoxButtons.OK);
                }
                else if(string.IsNullOrEmpty(txtDeOpen.Text))
                {
                    MessageBox.Show("Please enter password to decrypt a Presentation", "Password Missing", MessageBoxButtons.OK);
                }
                else
                {

                    //Creates instance for the presentation
                    IPresentation presentation = Presentation.Open(txtDecryptSource.Tag.ToString(), txtDeOpen.Text);
                    //Decrypts the document
                    presentation.RemoveEncryption();
                    //Saves the presentation
                    presentation.Save("Decryption.pptx");
                    //Closes the presentation
                    presentation.Close();

                    if (MessageBox.Show("Do you want to view the decrypted Presentation?", "Presentation Decrypted",
                            MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.Yes)
                    {
#if !NETCore
                        System.Diagnostics.Process.Start("Decryption.pptx");
#else
                        System.Diagnostics.Process process = new System.Diagnostics.Process();
                        process.StartInfo = new System.Diagnostics.ProcessStartInfo("Decryption.pptx")
                        {
                            UseShellExecute = true
                        };
                        process.Start();
#endif
                    }
                }
            }
            catch(Exception exp)
            {
                MessageBox.Show("Please enter correct password", "Incorrect Password",
                      MessageBoxButtons.OK);
            }
        }
        #endregion
    }
}
